<?php
/**
 * Système d'authentification sécurisé
 * Utilise password_verify() pour vérifier le mot de passe
 */

session_start();

// Hash du mot de passe (généré par generer_hash.php)
// Remplacez cette valeur par le hash que vous avez généré
$hash_stocke = '$2y$10$71Nb4hnstwytmQZT9.ItBOEnHRC0t0oZYV9IGWoyldNWD2.xTXEvm';

// Identifiant valide
$identifiant_valide = 'admin';

// Variables pour les messages
$erreur = '';

// Traitement du formulaire
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $identifiant = $_POST['identifiant'] ?? '';
    $mot_de_passe = $_POST['mot_de_passe'] ?? '';
    
    // Vérification de l'identifiant et du mot de passe
    if ($identifiant === $identifiant_valide && password_verify($mot_de_passe, $hash_stocke)) {
        // Authentification réussie
        $_SESSION['connecte'] = true;
        $_SESSION['identifiant'] = $identifiant;
        $_SESSION['heure_connexion'] = date('H:i:s');
        
        // Redirection automatique vers la page domotique
        header('Location: domotique.php');
        exit;
    } else {
        // Authentification échouée
        $erreur = 'Identifiant ou mot de passe incorrect';
    }
}

// Déconnexion
if (isset($_GET['deconnexion'])) {
    session_destroy();
    header('Location: index.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Système d'authentification sécurisé</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .container {
            background: white;
            padding: 40px;
            border-radius: 10px;
            box-shadow: 0 10px 40px rgba(0, 0, 0, 0.2);
            max-width: 400px;
            width: 100%;
        }
        
        h1 {
            color: #333;
            margin-bottom: 10px;
            font-size: 28px;
        }
        
        .subtitle {
            color: #666;
            margin-bottom: 30px;
            font-size: 14px;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        label {
            display: block;
            margin-bottom: 8px;
            color: #555;
            font-weight: 500;
        }
        
        input[type="text"],
        input[type="password"] {
            width: 100%;
            padding: 12px;
            border: 2px solid #e0e0e0;
            border-radius: 5px;
            font-size: 16px;
            transition: border-color 0.3s;
        }
        
        input[type="text"]:focus,
        input[type="password"]:focus {
            outline: none;
            border-color: #667eea;
        }
        
        button {
            width: 100%;
            padding: 12px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            border-radius: 5px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: transform 0.2s;
        }
        
        button:hover {
            transform: translateY(-2px);
        }
        
        button:active {
            transform: translateY(0);
        }
        
        .erreur {
            background: #fee;
            color: #c33;
            padding: 12px;
            border-radius: 5px;
            margin-bottom: 20px;
            border-left: 4px solid #c33;
        }
        
        .succes {
            background: #efe;
            color: #3a3;
            padding: 20px;
            border-radius: 5px;
            border-left: 4px solid #3a3;
        }
        
        .info {
            background: #f0f8ff;
            padding: 15px;
            border-radius: 5px;
            margin-top: 20px;
            border-left: 4px solid #667eea;
            font-size: 14px;
        }
        
        .info-title {
            font-weight: 600;
            color: #667eea;
            margin-bottom: 8px;
        }
        
        .info-item {
            color: #555;
            margin: 5px 0;
        }
        
        .deconnexion {
            display: inline-block;
            margin-top: 15px;
            padding: 10px 20px;
            background: #f44336;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            transition: background 0.3s;
        }
        
        .deconnexion:hover {
            background: #d32f2f;
        }
        
        .session-info {
            margin-top: 15px;
            padding: 10px;
            background: #f5f5f5;
            border-radius: 5px;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Formulaire de connexion -->
        <h1>🔐 Connexion</h1>
        <p class="subtitle">Système d'authentification sécurisé</p>
        
        <?php if ($erreur): ?>
            <div class="erreur">
                ⚠️ <?php echo htmlspecialchars($erreur); ?>
            </div>
        <?php endif; ?>
        
        <form method="POST" action="">
            <div class="form-group">
                <label for="identifiant">Identifiant</label>
                <input type="text" id="identifiant" name="identifiant" required autocomplete="username">
            </div>
            
            <div class="form-group">
                <label for="mot_de_passe">Mot de passe</label>
                <input type="password" id="mot_de_passe" name="mot_de_passe" required autocomplete="current-password">
            </div>
            
            <button type="submit">Se connecter</button>
        </form>
        
        <div class="info">
            <div class="info-title">ℹ️ Informations de test</div>
            <div class="info-item"><strong>Identifiant :</strong> admin</div>
            <div class="info-item"><strong>Mot de passe :</strong> 1234</div>
            <div class="info-item" style="margin-top: 10px; font-size: 12px; color: #888;">
                🔒 Le mot de passe est sécurisé avec password_hash()
            </div>
        </div>
    </div>
    
    <!-- Script de validation du formulaire -->
    <script src="script.js"></script>
</body>
</html>
