<?php
/**
 * Page Domotique - Mesures physiques
 * Accessible uniquement après authentification
 */

session_start();

// Vérification de l'authentification
if (!isset($_SESSION['connecte']) || $_SESSION['connecte'] !== true) {
    header('Location: index.php');
    exit;
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Domotique | Mesures</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            padding: 20px;
        }
        
        .page-container {
            max-width: 1200px;
            margin: 0 auto;
        }
        
        /* En-tête */
        .header {
            background: white;
            border-radius: 10px 10px 0 0;
            padding: 20px 30px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            display: flex;
            align-items: center;
            justify-content: space-between;
        }
        
        .logo-section {
            display: flex;
            align-items: center;
        }
        
        .logo-section h1 {
            color: #333;
            font-size: 26px;
            margin: 0;
        }
        
        .user-info {
            display: flex;
            align-items: center;
            gap: 15px;
            background: #f0f8ff;
            padding: 10px 15px;
            border-radius: 5px;
        }
        
        .user-info span {
            color: #555;
            font-size: 14px;
        }
        
        .btn-deconnexion {
            padding: 8px 16px;
            background: #f44336;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            font-size: 14px;
            transition: background 0.3s;
        }
        
        .btn-deconnexion:hover {
            background: #d32f2f;
        }
        
        /* Contenu principal */
        .main-content {
            background: white;
            padding: 30px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
        }
        
        .content-grid {
            display: grid;
            grid-template-columns: 1fr 400px;
            gap: 30px;
        }
        
        .info-section h2 {
            color: #667eea;
            font-size: 20px;
            margin-bottom: 15px;
            border-left: 4px solid #667eea;
            padding-left: 15px;
        }
        
        .info-section p {
            color: #555;
            line-height: 1.6;
            margin-bottom: 15px;
        }
        
        .info-section a {
            color: #667eea;
            text-decoration: none;
            font-weight: 500;
        }
        
        .info-section a:hover {
            text-decoration: underline;
        }
        
        .info-section ul {
            margin-left: 20px;
            margin-bottom: 20px;
            color: #555;
        }
        
        .info-section li {
            margin-bottom: 8px;
            line-height: 1.5;
        }
        
        /* Tableau des mesures */
        .mesures-section {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 10px;
            padding: 20px;
            color: white;
            height: fit-content;
        }
        
        .mesures-section h2 {
            font-size: 20px;
            margin-bottom: 15px;
            text-align: center;
        }
        
        .mesures-table {
            width: 100%;
            border-collapse: collapse;
            background: white;
            border-radius: 8px;
            overflow: hidden;
        }
        
        .mesures-table thead {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
        }
        
        .mesures-table thead th {
            padding: 15px;
            text-align: left;
            font-weight: 600;
            font-size: 14px;
        }
        
        .mesures-table tbody tr {
            border-bottom: 1px solid #e0e0e0;
            transition: background 0.2s;
        }
        
        .mesures-table tbody tr:last-child {
            border-bottom: none;
        }
        
        .mesures-table tbody tr:hover {
            background: #f5f5f5;
        }
        
        .mesures-table tbody td {
            padding: 15px;
            color: #333;
        }
        
        .mesure-name {
            font-weight: 500;
            color: #667eea;
        }
        
        .mesure-value {
            font-weight: 600;
            font-size: 18px;
            text-align: center;
            color: #764ba2;
        }
        
        .mesure-unit {
            color: #888;
            font-size: 14px;
            text-align: center;
        }
        
        /* Pied de page */
        .footer {
            background: white;
            border-radius: 0 0 10px 10px;
            padding: 15px 30px;
            box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
            text-align: center;
            color: #888;
            font-size: 14px;
        }
        
        /* Cartes de capteurs */
        .sensor-cards {
            display: grid;
            grid-template-columns: repeat(2, 1fr);
            gap: 15px;
            margin-top: 20px;
        }
        
        .sensor-card {
            background: #f8f9fa;
            border-left: 4px solid #667eea;
            padding: 15px;
            border-radius: 5px;
        }
        
        .sensor-card h3 {
            color: #667eea;
            font-size: 16px;
            margin-bottom: 8px;
        }
        
        .sensor-card p {
            font-size: 13px;
            color: #666;
            margin-bottom: 5px;
        }
        
        /* Responsive */
        @media (max-width: 968px) {
            .content-grid {
                grid-template-columns: 1fr;
            }
            
            .header {
                flex-direction: column;
                gap: 15px;
                text-align: center;
            }
            
            .sensor-cards {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <div class="page-container">
        <!-- En-tête -->
        <div class="header">
            <div class="logo-section">
                <h1>🏠 Mesures physiques et domotique</h1>
            </div>
            <div class="user-info">
                <span>👤 <strong><?php echo htmlspecialchars($_SESSION['identifiant']); ?></strong></span>
                <a href="index.php?deconnexion" class="btn-deconnexion">Se déconnecter</a>
            </div>
        </div>
        
        <!-- Contenu principal -->
        <div class="main-content">
            <div class="content-grid">
                <!-- Informations sur les capteurs -->
                <div class="info-section">
                    <h2>📡 Capteurs utilisés</h2>
                    
                    <p>Les mesures de température, d'humidité et de pression sont réalisées par un capteur <strong>BME280</strong>
                    (<a href="https://learn.sparkfun.com/tutorials/sparkfun-bme280-breakout-hookup-guide/all" target="_blank">Sparkfun</a>).</p>
                    
                    <ul>
                        <li><strong>Température :</strong> de -40°C à 85°C, précision ±1°C</li>
                        <li><strong>Humidité :</strong> de 0 à 100% HR, précision ±3%</li>
                        <li><strong>Pression :</strong> 30 kPa à 110 kPa, précision ±1 hPa</li>
                    </ul>
                    
                    <p>La mesure de luminosité est réalisée par un capteur <strong>BH1750</strong> 
                    (<a href="https://wiki.dfrobot.com/Light_Sensor__SKU_SEN0097_" target="_blank">DFRobot</a>).</p>
                    
                    <ul>
                        <li><strong>Plage de mesure :</strong> 0 à 65 536 lux</li>
                        <li><strong>Précision :</strong> 1,2 lux</li>
                    </ul>
                    
                    <div class="sensor-cards">
                        <div class="sensor-card">
                            <h3>🌡️ BME280</h3>
                            <p>Capteur environnemental multifonction</p>
                            <p><strong>I²C/SPI</strong> • 3.3V-5V</p>
                        </div>
                        <div class="sensor-card">
                            <h3>💡 BH1750</h3>
                            <p>Capteur de lumière ambiante</p>
                            <p><strong>I²C</strong> • 3.3V-5V</p>
                        </div>
                    </div>
                </div>
                
                <!-- Tableau des mesures -->
                <div class="mesures-section">
                    <h2>📊 Mesures en temps réel</h2>
                    <table class="mesures-table">
                        <thead>
                            <tr>
                                <th>Mesure</th>
                                <th style="text-align: center;">Valeur</th>
                                <th style="text-align: center;">Unité</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td class="mesure-name">🌡️ Température</td>
                                <td class="mesure-value">20</td>
                                <td class="mesure-unit">°C</td>
                            </tr>
                            <tr>
                                <td class="mesure-name">💧 Humidité</td>
                                <td class="mesure-value">61</td>
                                <td class="mesure-unit">%</td>
                            </tr>
                            <tr>
                                <td class="mesure-name">📊 Pression</td>
                                <td class="mesure-value">980</td>
                                <td class="mesure-unit">hPa</td>
                            </tr>
                            <tr>
                                <td class="mesure-name">💡 Luminosité</td>
                                <td class="mesure-value">250</td>
                                <td class="mesure-unit">lux</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        
        <!-- Pied de page -->
        <div class="footer">
            2025-2026 - Terminale - STI2D - SIN - Lycée Pierre Emile Martin - 1, Avenue de Gionne - 18000 Bourges
        </div>
    </div>
</body>
</html>
