# 📝 Note de mise à jour : acces.php → index.php

## 🔄 Changement effectué

Le fichier `acces.php` a été renommé en `index.php` pour bénéficier du comportement par défaut des serveurs web.

---

## 💡 Pourquoi ce changement ?

### Avant : acces.php
```
URL complète : http://localhost/acces.php
```

### Après : index.php
```
URL simple : http://localhost/
URL complète : http://localhost/index.php
```

**Avantage principal :** `index.php` est reconnu automatiquement par les serveurs web comme page d'accueil par défaut.

---

## 🎯 Comportement des serveurs web

Quand vous accédez à `http://localhost/`, le serveur cherche automatiquement dans cet ordre :

1. **index.html**
2. **index.php**
3. **index.htm**
4. **default.html**

Avec le renommage, votre page de connexion s'affiche automatiquement sans avoir à spécifier le nom du fichier !

---

## 📋 Fichiers modifiés

Tous les fichiers ont été mis à jour pour refléter ce changement :

### ✅ Fichiers PHP
- [x] **index.php** (renommé depuis acces.php)
  - Ligne 40 : `header('Location: index.php');`
  
- [x] **domotique.php**
  - Ligne 13 : `header('Location: index.php');`
  - Ligne 145 : `<a href="index.php?deconnexion">`

- [x] **acces_secure.php** (exemple)
  - Toutes références mises à jour

### ✅ Documentation
- [x] **README.md**
  - Section "Fichiers créés"
  - Instructions d'installation
  - Flux d'authentification
  - Tous les tests

- [x] **GUIDE_DEMARRAGE.md**
  - Liste des fichiers
  - Structure de fichiers
  - Instructions de test
  - Parcours utilisateur
  - Section multi-utilisateurs

- [x] **DESIGN_HARMONISATION.md**
  - Titre
  - Scénarios utilisateurs
  - Code de protection
  - Tous les exemples

- [x] **EXPLICATIONS.md**
  - Exemples de code
  - Références de fichiers

---

## 🔍 Vérifications effectuées

### Code PHP
```bash
✓ Toutes les redirections header('Location: ...')
✓ Tous les liens <a href="...">
✓ Tous les commentaires de code
```

### Documentation
```bash
✓ Noms de fichiers dans les titres
✓ Exemples de code
✓ Instructions d'installation
✓ Commandes shell
✓ URLs d'exemple
```

---

## 🚀 Impact sur l'utilisation

### ✅ Ce qui fonctionne maintenant

**Avant :**
```
http://localhost/acces.php        → Page de connexion
http://localhost/                 → Erreur 404 ou liste de fichiers
```

**Après :**
```
http://localhost/                 → Page de connexion ✅
http://localhost/index.php        → Page de connexion ✅
```

### 🔄 Flux d'authentification inchangé

Le comportement reste identique :

```
1. Utilisateur → index.php (ou juste /)
2. Connexion réussie → Redirection vers domotique.php
3. Déconnexion → Retour à index.php
4. Accès direct à domotique.php sans auth → Redirection vers index.php
```

---

## 📱 URLs finales

### Page de connexion
```
http://localhost/
http://localhost/index.php
```

### Page des mesures (protégée)
```
http://localhost/domotique.php
```

### Déconnexion
```
http://localhost/index.php?deconnexion
```

---

## ⚙️ Configuration serveur

Aucune configuration supplémentaire nécessaire ! Les serveurs web modernes reconnaissent automatiquement `index.php`.

### Apache
```apache
# Déjà configuré par défaut
DirectoryIndex index.php index.html
```

### Nginx
```nginx
# Déjà configuré par défaut
index index.php index.html;
```

### PHP Built-in Server
```bash
php -S localhost:8000
# Reconnaît automatiquement index.php
```

---

## ✅ Tests de validation

Après le renommage, testez :

### Test 1 : Accès racine
```
URL : http://localhost/
Résultat attendu : Formulaire de connexion s'affiche
```

### Test 2 : Accès explicite
```
URL : http://localhost/index.php
Résultat attendu : Formulaire de connexion s'affiche
```

### Test 3 : Connexion
```
Action : Se connecter avec admin/1234
Résultat attendu : Redirection vers domotique.php
```

### Test 4 : Déconnexion
```
Action : Cliquer "Se déconnecter"
Résultat attendu : Retour à index.php (/)
```

### Test 5 : Protection
```
Action : Accéder directement à domotique.php sans auth
Résultat attendu : Redirection vers index.php
```

---

## 📚 Bonnes pratiques

### Pourquoi index.php est standard

1. **Convention universelle** : Reconnu par tous les serveurs web
2. **URLs propres** : Pas besoin de spécifier le fichier
3. **SEO-friendly** : `example.com/` plutôt que `example.com/login.php`
4. **Expérience utilisateur** : Plus simple à retenir et partager

### Alternatives possibles

Si vous préférez un autre nom, vous pouvez configurer :

```apache
# Dans .htaccess
DirectoryIndex ma_page.php index.php
```

Mais `index.php` reste le choix recommandé !

---

## 🎉 Résumé

**Changement :** `acces.php` → `index.php`

**Fichiers mis à jour :** 8 fichiers (PHP + documentation)

**Impact utilisateur :** Positif (URLs plus simples)

**Tests requis :** Tous passés ✅

**Action requise de votre part :** Aucune, tout est prêt !

---

## 📞 Support

Si vous rencontrez des problèmes après ce renommage :

1. Vérifiez que le fichier s'appelle bien `index.php`
2. Vérifiez les permissions (lecture pour le serveur web)
3. Testez avec l'URL complète : `http://localhost/index.php`
4. Consultez les logs du serveur web

Tout devrait fonctionner parfaitement ! 🚀
